<?php
session_start();
require '../conexion.php';

// Verificar si el usuario está logueado y es administrador
if (!isset($_SESSION['username']) || !isset($_SESSION['rol']) || ($_SESSION['rol'] !== 'admin' && $_SESSION['rol'] !== 'empleado')) {
    header("Location: ../login.php");
    exit;
}

// Procesar la subida de imagen al carrusel
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['agregar_imagen'])) {
    $descripcion = $_POST['descripcion'];
    $orden = $_POST['orden'];
    $activo = isset($_POST['activo']) ? 1 : 0;
    
    // Manejar la imagen
    if (isset($_FILES['imagen']) && $_FILES['imagen']['error'] == 0) {
        $imagen_nombre = basename($_FILES['imagen']['name']);
        $imagen_temp = $_FILES['imagen']['tmp_name'];
        $carpeta_destino = "../img/";
        
        // Crear la carpeta si no existe
        if (!file_exists($carpeta_destino)) {
            mkdir($carpeta_destino, 0777, true);
        }
        
        if (move_uploaded_file($imagen_temp, $carpeta_destino . $imagen_nombre)) {
            // Debug: Log the image path
            error_log("Uploaded image to: " . $carpeta_destino . $imagen_nombre);
            
            // Insertar en la base de datos
            $query = "INSERT INTO carrusel (imagen_url, descripcion, orden, activo) VALUES (?, ?, ?, ?)";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ssii", $imagen_nombre, $descripcion, $orden, $activo);
            
            if ($stmt->execute()) {
                $success_message = "Imagen agregada correctamente al carrusel.";
            } else {
                $error = "Error al agregar la imagen: " . $conn->error;
            }
        } else {
            $error = "Error al subir la imagen.";
        }
    } else {
        $error = "Debes seleccionar una imagen.";
    }
}

// Procesar la eliminación de imagen
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['eliminar_imagen'])) {
    $imagen_id = $_POST['imagen_id'];
    
    // Obtener la información de la imagen
    $query_imagen = "SELECT imagen_url FROM carrusel WHERE id = ?";
    $stmt_imagen = $conn->prepare($query_imagen);
    $stmt_imagen->bind_param("i", $imagen_id);
    $stmt_imagen->execute();
    $result_imagen = $stmt_imagen->get_result();
    $imagen = $result_imagen->fetch_assoc();
    
    // Eliminar de la base de datos
    $query = "DELETE FROM carrusel WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $imagen_id);
    
    if ($stmt->execute()) {
        // Eliminar el archivo si existe
        if (!empty($imagen['imagen_url'])) {
            $ruta_imagen = "../img/" . $imagen['imagen_url'];
            if (file_exists($ruta_imagen)) {
                unlink($ruta_imagen);
            }
        }
        $success_message = "Imagen eliminada correctamente.";
    } else {
        $error = "Error al eliminar la imagen: " . $conn->error;
    }
}

// Obtener la lista de imágenes del carrusel
$query_carrusel = "SELECT * FROM carrusel ORDER BY orden ASC";
$result_carrusel = mysqli_query($conn, $query_carrusel);

// Obtener el nombre del rol para mostrar en la interfaz
$rol_usuario = $_SESSION['rol'];
$nombre_usuario = $_SESSION['username'];
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión del Carrusel</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
       <link rel="stylesheet" href="../CSS/prodcutos.css">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm py-2">
        <div class="container-fluid">
            <button class="btn btn-link text-white d-lg-none" id="sidebar-toggle">
                <i class="bi bi-list fs-4"></i>
            </button>
            <a class="navbar-brand ms-2" href="#">
                <i class="bi bi-speedometer2 fs-4 me-2"></i>
                <span class="fw-bold">AdminPanel</span>
            </a>
            <div class="ms-auto d-flex align-items-center">
                <div class="dropdown">
                    <button class="btn btn-primary dropdown-toggle d-flex align-items-center" type="button" id="userDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                        <img src="../Img/admin.jpg" alt="Admin" width="32" height="32" class="rounded-circle me-2">
                        <span><?php echo htmlspecialchars($nombre_usuario); ?></span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                        <li><a class="dropdown-item" href="#">Mi perfil</a></li>
                        <li><a class="dropdown-item" href="#">Configuración</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="../logout.php">Cerrar sesión</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>

    <!-- Overlay -->
    <div class="overlay" id="sidebar-overlay"></div>

    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="d-flex flex-column p-4">
            <div class="text-center mb-4">
                <img src="../Img/admin.jpg" alt="Perfil" class="rounded-circle mb-2" width="80" height="80">
                <h6 class="text-white"><?php echo htmlspecialchars($nombre_usuario); ?></h6>
                <span class="badge bg-light text-primary"><?php echo ucfirst(htmlspecialchars($rol_usuario)); ?></span>
            </div>

            <ul class="nav flex-column mt-2">
                <li class="nav-item">
                    <a class="nav-link" href="../Admin/dashboard.php">
                        <i class="bi bi-house-door me-2"></i> Dashboard
                    </a>
                </li>
                
                <?php if ($_SESSION['rol'] === 'admin'): ?>
                <li class="nav-item">
                    <a class="nav-link" href="../Admin/usuarios.php">
                        <i class="bi bi-people me-2"></i> Usuarios
                    </a>
                </li>
                <?php endif; ?>
                
                <li class="nav-item">
                    <a class="nav-link active" href="../Admin/carrusel.php">
                        <i class="bi bi-images me-2"></i> Carrusel
                    </a>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link" href="../Admin/productos.php">
                        <i class="bi bi-box-seam me-2"></i> Productos
                    </a>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link" href="../index.php">
                        <i class="bi bi-display me-2"></i> Ver sitio
                    </a>
                </li>
                
                <li class="nav-item mt-5">
                    <a class="nav-link bg-danger text-white" href="../logout.php">
                        <i class="bi bi-box-arrow-right me-2"></i> Cerrar sesión
                    </a>
                </li>
            </ul>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content content-wrapper">
        <div class="container-fluid">
            <header class="d-flex justify-content-between align-items-center py-3 mb-4 border-bottom">
                <h2 class="h2 fw-bold">Gestión del Carrusel</h2>
            </header>

            <!-- Mensajes de éxito o error -->
            <?php if(isset($success_message)): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo htmlspecialchars($success_message); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            
            <?php if(isset($error)): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo htmlspecialchars($error); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <!-- Formulario para agregar imagen -->
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-white py-3">
                    <h5 class="card-title mb-0 fw-bold">Agregar Nueva Imagen al Carrusel</h5>
                </div>
                <div class="card-body">
                    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="agregar_imagen" value="1">
                        <div class="row mb-3">
                            <div class="col-md-6 mb-3">
                                <label for="imagen" class="form-label">Imagen</label>
                                <input type="file" class="form-control" id="imagen" name="imagen" accept="image/*" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="orden" class="form-label">Orden</label>
                                <input type="number" class="form-control" id="orden" name="orden" min="0" value="0" required>
                            </div>
                            <div class="col-12 mb-3">
                                <label for="descripcion" class="form-label">Descripción</label>
                                <textarea class="form-control" id="descripcion" name="descripcion" rows="3"></textarea>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="activo" name="activo" checked>
                                    <label class="form-check-label" for="activo">
                                        Mostrar en el carrusel
                                    </label>
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-plus-circle me-2"></i> Agregar Imagen
                        </button>
                    </form>
                </div>
            </div>

            <!-- Lista de imágenes del carrusel -->
            <div class="card shadow-sm">
                <div class="card-header bg-white py-3">
                    <h5 class="card-title mb-0 fw-bold">Imágenes en el Carrusel</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Imagen</th>
                                    <th>Descripción</th>
                                    <th>Orden</th>
                                    <th>Activo</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($imagen = mysqli_fetch_assoc($result_carrusel)): ?>
                                <tr>
                                    <td><?php echo $imagen['id']; ?></td>
                                    <td>
                                        <img src="../img/<?php echo htmlspecialchars($imagen['imagen_url']); ?>" alt="Imagen del carrusel" class="img-preview">
                                    </td>
                                    <td><?php echo htmlspecialchars($imagen['descripcion']); ?></td>
                                    <td><?php echo $imagen['orden']; ?></td>
                                    <td>
                                        <span class="badge <?php echo $imagen['activo'] ? 'bg-success' : 'bg-danger'; ?>">
                                            <?php echo $imagen['activo'] ? 'Sí' : 'No'; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div class="d-flex gap-2">
                                            <a href="editar_carrusel.php?id=<?php echo $imagen['id']; ?>" class="btn btn-sm btn-primary">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST" onsubmit="return confirm('¿Estás seguro de que deseas eliminar esta imagen?');" class="d-inline">
                                                <input type="hidden" name="eliminar_imagen" value="1">
                                                <input type="hidden" name="imagen_id" value="<?php echo $imagen['id']; ?>">
                                                <button type="submit" class="btn btn-sm btn-danger">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                                <?php if (mysqli_num_rows($result_carrusel) == 0): ?>
                                <tr>
                                    <td colspan="6" class="text-center py-4">No hay imágenes en el carrusel</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Sidebar toggle functionality
            const sidebarToggle = document.getElementById('sidebar-toggle');
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');
            
            if (sidebarToggle && sidebar && overlay) {
                sidebarToggle.addEventListener('click', function() {
                    sidebar.classList.toggle('show');
                    overlay.classList.toggle('show');
                });
                
                overlay.addEventListener('click', function() {
                    sidebar.classList.remove('show');
                    overlay.classList.remove('show');
                });
            }
            
            // Close sidebar when clicking on a nav link (mobile only)
            const navLinks = document.querySelectorAll('.sidebar .nav-link');
            navLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth < 992) {
                        sidebar.classList.remove('show');
                        overlay.classList.remove('show');
                    }
                });
            });
            
            // Handle window resize
            window.addEventListener('resize', function() {
                if (window.innerWidth >= 992) {
                    sidebar.classList.remove('show');
                    overlay.classList.remove('show');
                }
            });
        });
    </script>
</body>
</html>