<?php
session_start();
require '../conexion.php';

// Verificar si el usuario está autenticado y tiene permisos de admin o empleado
if (!isset($_SESSION['username']) || !isset($_SESSION['rol']) || ($_SESSION['rol'] !== 'admin' && $_SESSION['rol'] !== 'empleado')) {
    header("Location: ../login.php");
    exit;
}
// Obtener estadísticas
$query_usuarios = "SELECT COUNT(*) as total FROM usuarios";
$result_usuarios = mysqli_query($conn, $query_usuarios);
$total_usuarios = mysqli_fetch_assoc($result_usuarios)['total'];

$query_productos = "SELECT COUNT(*) as total FROM productos";
$result_productos = mysqli_query($conn, $query_productos);
$total_productos = mysqli_fetch_assoc($result_productos)['total'];

$query_carrusel = "SELECT COUNT(*) as total FROM carrusel";
$result_carrusel = mysqli_query($conn, $query_carrusel);
$total_carrusel = mysqli_fetch_assoc($result_carrusel)['total'];

// Obtener el nombre del rol para mostrar en la interfaz
$rol_usuario = $_SESSION['rol'];
$nombre_usuario = $_SESSION['username'];
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Administrativo</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="stylesheet" href="../CSS/style2.css">

</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm py-2">
        <div class="container-fluid">
            <button class="btn btn-link text-white d-lg-none" id="sidebar-toggle">
                <i class="bi bi-list fs-4"></i>
            </button>
            <a class="navbar-brand ms-2" href="#">
                <i class="bi bi-speedometer2 fs-4 me-2"></i>
                <span class="fw-bold">AdminPanel</span>
            </a>
            <div class="ms-auto d-flex align-items-center">
                <div class="dropdown">
                    <button class="btn btn-primary dropdown-toggle d-flex align-items-center" type="button" id="userDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                        <img src="../Img/admin.jpg" alt="Admin" width="32" height="32" class="rounded-circle me-2">
                        <span><?php echo htmlspecialchars($nombre_usuario); ?></span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                        <li><a class="dropdown-item" href="#">Mi perfil</a></li>
                        <li><a class="dropdown-item" href="#">Configuración</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="../logout.php">Cerrar sesión</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>

    <!-- Overlay -->
    <div class="overlay" id="sidebar-overlay"></div>

    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="d-flex flex-column p-4">
            <div class="text-center mb-4">
                <img src="../Img/admin.jpg" alt="Perfil" class="rounded-circle mb-2" width="80" height="80">
                <h6 class="text-white"><?php echo htmlspecialchars($nombre_usuario); ?></h6>
                <span class="badge bg-light text-primary"><?php echo ucfirst(htmlspecialchars($rol_usuario)); ?></span>
            </div>

            <ul class="nav flex-column mt-2">
                <li class="nav-item">
                    <a class="nav-link active" href="../Admin/dashboard.php">
                        <i class="bi bi-house-door me-2"></i> Dashboard
                    </a>
                </li>
                
                <?php if ($_SESSION['rol'] === 'admin'): ?>
                <li class="nav-item">
                    <a class="nav-link" href="../Admin/usuarios.php">
                        <i class="bi bi-people me-2"></i> Usuarios
                    </a>
                </li>
                <?php endif; ?>
                
                <li class="nav-item">
                    <a class="nav-link" href="../Admin/carrusel.php">
                        <i class="bi bi-images me-2"></i> Carrusel
                    </a>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link" href="../Admin/productos.php">
                        <i class="bi bi-box-seam me-2"></i> Productos
                    </a>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link" href="../index.php">
                        <i class="bi bi-display me-2"></i> Ver sitio
                    </a>
                </li>
                
                <li class="nav-item mt-5">
                    <a class="nav-link bg-danger text-white" href="../logout.php">
                        <i class="bi bi-box-arrow-right me-2"></i> Cerrar sesión
                    </a>
                </li>
            </ul>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content content-wrapper">
        <div class="container-fluid">
            <header class="d-flex justify-content-between align-items-center py-3 mb-4 border-bottom">
                <h2 class="h2 fw-bold">Dashboard</h2>
            </header>

            <!-- Stats Cards -->
            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 mb-4">
                <div class="col">
                    <div class="card shadow stats-card border-0 bg-primary bg-opacity-10 h-100">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <h6 class="card-title text-muted mb-1">Total Productos</h6>
                                    <h2 class="fw-bold mb-0"><?php echo $total_productos; ?></h2>
                                    <p class="text-muted mt-2 mb-0"><small>Productos registrados en el sistema</small></p>
                                </div>
                                <div class="bg-primary text-white p-3 rounded">
                                    <i class="bi bi-box-seam fs-3"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col">
                    <div class="card shadow stats-card border-0 bg-success bg-opacity-10 h-100">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <h6 class="card-title text-muted mb-1">Total Carrusel</h6>
                                    <h2 class="fw-bold mb-0"><?php echo $total_carrusel; ?></h2>
                                    <p class="text-muted mt-2 mb-0"><small>Imágenes en el carrusel</small></p>
                                </div>
                                <div class="bg-success text-white p-3 rounded">
                                    <i class="bi bi-images fs-3"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <?php if ($_SESSION['rol'] === 'admin'): ?>
                <div class="col">
                    <div class="card shadow stats-card border-0 bg-info bg-opacity-10 h-100">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <h6 class="card-title text-muted mb-1">Total Usuarios</h6>
                                    <h2 class="fw-bold mb-0"><?php echo $total_usuarios; ?></h2>
                                    <p class="text-muted mt-2 mb-0"><small>Usuarios registrados en el sistema</small></p>
                                </div>
                                <div class="bg-info text-white p-3 rounded">
                                    <i class="bi bi-people fs-3"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <!-- Welcome Card -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card welcome-card shadow-lg border-0">
                        <div class="card-body p-4 p-lg-5 text-center">
                            <h1 class="display-5 fw-bold mb-4">¡Bienvenido al Panel Administrativo!</h1>
                            <p class="lead mb-4">
                                Gestiona todo el contenido del sitio web de manera eficiente. 
                                <?php if ($_SESSION['rol'] === 'admin'): ?>
                                Como administrador, tienes acceso completo a todas las funciones.
                                <?php else: ?>
                                Como empleado, puedes gestionar productos y carrusel.
                                <?php endif; ?>
                            </p>
                            
                            <div class="d-grid gap-2 d-sm-flex flex-wrap justify-content-center mt-4">
                                <?php if ($_SESSION['rol'] === 'admin'): ?>
                                <a href="../Admin/usuarios.php" class="btn btn-light btn-lg px-4 m-2">
                                    <i class="bi bi-people me-2"></i> Gestionar Usuarios
                                </a>
                                <?php endif; ?>
                                <a href="../Admin/productos.php" class="btn btn-light btn-lg px-4 m-2">
                                    <i class="bi bi-box-seam me-2"></i> Gestionar Productos
                                </a>
                                <a href="../Admin/carrusel.php" class="btn btn-light btn-lg px-4 m-2">
                                    <i class="bi bi-images me-2"></i> Gestionar Carrusel
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

           
        </div>
    </div>

    <!-- Bootstrap 5 JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Sidebar toggle functionality
            const sidebarToggle = document.getElementById('sidebar-toggle');
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');
            
            if (sidebarToggle && sidebar && overlay) {
                sidebarToggle.addEventListener('click', function() {
                    sidebar.classList.toggle('show');
                    overlay.classList.toggle('show');
                });
                
                overlay.addEventListener('click', function() {
                    sidebar.classList.remove('show');
                    overlay.classList.remove('show');
                });
            }
            
            // Close sidebar when clicking on a nav link (mobile only)
            const navLinks = document.querySelectorAll('.sidebar .nav-link');
            navLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth < 992) {
                        sidebar.classList.remove('show');
                        overlay.classList.remove('show');
                    }
                });
            });
            
            // Handle window resize
            window.addEventListener('resize', function() {
                if (window.innerWidth >= 992) {
                    sidebar.classList.remove('show');
                    overlay.classList.remove('show');
                }
            });
            
     });
    </script>
</body>
</html>