<?php
session_start();
require '../conexion.php';

// Verificar si el usuario está logueado y es administrador
if (!isset($_SESSION['username']) || !isset($_SESSION['rol']) || $_SESSION['rol'] !== 'admin') {
    header("Location: ../login.php");
    exit;
}

// Verificar si se ha proporcionado un ID de imagen
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: carrusel.php");
    exit;
}

$imagen_id = $_GET['id'];

// Obtener los datos de la imagen
$query = "SELECT * FROM carrusel WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $imagen_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    header("Location: carrusel.php");
    exit;
}

$imagen = $result->fetch_assoc();

// Procesar la actualización de la imagen
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['actualizar_imagen'])) {
    $descripcion = $_POST['descripcion'];
    $orden = $_POST['orden'];
    $activo = isset($_POST['activo']) ? 1 : 0;
    
    // Manejar la imagen
    $imagen_url = $imagen['imagen_url']; // Mantener la imagen actual por defecto
    
    if (isset($_FILES['imagen']) && $_FILES['imagen']['error'] == 0) {
        $imagen_nombre = basename($_FILES['imagen']['name']);
        $imagen_temp = $_FILES['imagen']['tmp_name'];
        $carpeta_destino = "../img/";
        
        // Crear la carpeta si no existe
        if (!file_exists($carpeta_destino)) {
            mkdir($carpeta_destino, 0777, true);
        }
        
        if (move_uploaded_file($imagen_temp, $carpeta_destino . $imagen_nombre)) {
            // Si hay una imagen anterior, eliminarla
            if (!empty($imagen['imagen_url'])) {
                $ruta_imagen_anterior = $carpeta_destino . $imagen['imagen_url'];
                if (file_exists($ruta_imagen_anterior)) {
                    unlink($ruta_imagen_anterior);
                }
            }
            $imagen_url = $imagen_nombre;
        } else {
            $error = "Error al subir la nueva imagen.";
        }
    }
    
    // Actualizar la imagen en la base de datos
    if (!isset($error)) {
        $query = "UPDATE carrusel SET imagen_url = ?, descripcion = ?, orden = ?, activo = ? WHERE id = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("ssiii", $imagen_url, $descripcion, $orden, $activo, $imagen_id);
        
        if ($stmt->execute()) {
            $success_message = "Imagen actualizada correctamente.";
            // Actualizar los datos de la imagen para mostrar los cambios
            $imagen['imagen_url'] = $imagen_url;
            $imagen['descripcion'] = $descripcion;
            $imagen['orden'] = $orden;
            $imagen['activo'] = $activo;
        } else {
            $error = "Error al actualizar la imagen: " . $conn->error;
        }
    }
}

// Obtener el nombre del rol para mostrar en la interfaz
$rol_usuario = $_SESSION['rol'];
$nombre_usuario = $_SESSION['username'];
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Imagen del Carrusel</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="../CSS/style3.css">
</head>
<body class="bg-light">
    <div class="container py-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="fw-bold"><i class="bi bi-pencil-square me-2"></i>Editar Imagen del Carrusel</h2>
            <a href="carrusel.php" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Volver al Carrusel
            </a>
        </div>

        <!-- Mensajes de éxito o error -->
        <?php if(isset($success_message)): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo htmlspecialchars($success_message); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        
        <?php if(isset($error)): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo htmlspecialchars($error); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <!-- Formulario para editar imagen -->
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-white py-3">
                <h5 class="card-title mb-0 fw-bold">Editar Imagen ID: <?php echo $imagen_id; ?></h5>
            </div>
            <div class="card-body">
                <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"] . "?id=" . $imagen_id); ?>" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="actualizar_imagen" value="1">
                    <div class="row mb-4">
                        <div class="col-md-6 mb-3">
                            <label for="imagen" class="form-label">Imagen Actual</label>
                            <div class="mb-3">
                                <img src="../img/<?php echo htmlspecialchars($imagen['imagen_url']); ?>" alt="Imagen del carrusel" class="img-preview mb-2">
                            </div>
                            <input type="file" class="form-control" id="imagen" name="imagen" accept="image/*">
                            <div class="form-text">Deja este campo vacío para mantener la imagen actual.</div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="orden" class="form-label">Orden</label>
                                <input type="number" class="form-control" id="orden" name="orden" min="0" value="<?php echo $imagen['orden']; ?>" required>
                            </div>
                            
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="activo" name="activo" <?php echo $imagen['activo'] ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="activo">
                                        Mostrar en el carrusel
                                    </label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-12 mb-3">
                            <label for="descripcion" class="form-label">Descripción</label>
                            <textarea class="form-control" id="descripcion" name="descripcion" rows="3"><?php echo htmlspecialchars($imagen['descripcion']); ?></textarea>
                        </div>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i>Guardar Cambios
                        </button>
                        <a href="carrusel.php" class="btn btn-secondary">
                            <i class="bi bi-x-circle me-2"></i>Cancelar
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>