<?php
session_start();
require '../conexion.php';

// Verificar si el usuario está logueado y es administrador
if (!isset($_SESSION['username']) || !isset($_SESSION['rol']) || $_SESSION['rol'] !== 'admin') {
    header("Location: ../login.php");
    exit;
}

// Verificar si se ha proporcionado un ID de producto
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: productos.php");
    exit;
}

$producto_id = $_GET['id'];

// Obtener los datos del producto
$query = "SELECT * FROM productos WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $producto_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    header("Location: productos.php");
    exit;
}

$producto = $result->fetch_assoc();

// Procesar la actualización del producto
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['actualizar_producto'])) {
    $nombre = $_POST['nombre'];
    $descripcion = $_POST['descripcion'];
    $precio = $_POST['precio'];
    $stock = $_POST['stock'];
    $destacado = isset($_POST['destacado']) ? 1 : 0;
    
    // Manejar la imagen
    $imagen = $producto['imagen']; // Mantener la imagen actual por defecto
    
    if (isset($_FILES['imagen']) && $_FILES['imagen']['error'] == 0) {
        $imagen_nombre = basename($_FILES['imagen']['name']);
        $imagen_temp = $_FILES['imagen']['tmp_name'];
        $carpeta_destino = "../img/productos/";
        
        // Crear la carpeta si no existe
        if (!file_exists($carpeta_destino)) {
            mkdir($carpeta_destino, 0777, true);
        }
        
        if (move_uploaded_file($imagen_temp, $carpeta_destino . $imagen_nombre)) {
            // Si hay una imagen anterior, eliminarla
            if (!empty($producto['imagen'])) {
                $ruta_imagen_anterior = $carpeta_destino . $producto['imagen'];
                if (file_exists($ruta_imagen_anterior)) {
                    unlink($ruta_imagen_anterior);
                }
            }
            $imagen = $imagen_nombre;
        } else {
            $error = "Error al subir la nueva imagen.";
        }
    }
    
    // Actualizar el producto en la base de datos
    if (!isset($error)) {
        $query = "UPDATE productos SET nombre = ?, descripcion = ?, precio = ?, imagen = ?, stock = ?, destacado = ? WHERE id = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("ssdsiii", $nombre, $descripcion, $precio, $imagen, $stock, $destacado, $producto_id);
        
        if ($stmt->execute()) {
            $success_message = "Producto actualizado correctamente.";
            // Actualizar los datos del producto para mostrar los cambios
            $producto['nombre'] = $nombre;
            $producto['descripcion'] = $descripcion;
            $producto['precio'] = $precio;
            $producto['imagen'] = $imagen;
            $producto['stock'] = $stock;
            $producto['destacado'] = $destacado;
        } else {
            $error = "Error al actualizar el producto: " . $conn->error;
        }
    }
}

// Obtener el nombre del rol para mostrar en la interfaz
$rol_usuario = $_SESSION['rol'];
$nombre_usuario = $_SESSION['username'];
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Producto</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="../CSS/style2.css">
</head>
<body>
    <div class="container py-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="fw-bold"><i class="bi bi-pencil-square me-2"></i>Editar Producto</h2>
            <a href="productos.php" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Volver a Productos
            </a>
        </div>

        <!-- Mensajes de éxito o error -->
        <?php if(isset($success_message)): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo htmlspecialchars($success_message); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        
        <?php if(isset($error)): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo htmlspecialchars($error); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <!-- Formulario para editar producto -->
        <div class="card shadow mb-4">
            <div class="card-header bg-primary bg-opacity-10 py-3">
                <h5 class="card-title mb-0 fw-bold">Editar Producto #<?php echo $producto_id; ?></h5>
            </div>
            <div class="card-body">
                <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"] . "?id=" . $producto_id); ?>" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="actualizar_producto" value="1">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="nombre" class="form-label">Nombre del Producto</label>
                            <input type="text" name="nombre" id="nombre" value="<?php echo htmlspecialchars($producto['nombre']); ?>" class="form-control" required>
                        </div>
                        <div class="col-md-3">
                            <label for="precio" class="form-label">Precio</label>
                            <div class="input-group">
                                <span class="input-group-text">Q</span>
                                <input type="number" name="precio" id="precio" step="0.01" min="0" value="<?php echo $producto['precio']; ?>" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label for="stock" class="form-label">Stock</label>
                            <input type="number" name="stock" id="stock" min="0" value="<?php echo $producto['stock']; ?>" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label for="imagen" class="form-label">Imagen</label>
                            <?php if (!empty($producto['imagen'])): ?>
                                <div class="mb-2">
                                    <img src="../img/productos/<?php echo htmlspecialchars($producto['imagen']); ?>" alt="<?php echo htmlspecialchars($producto['nombre']); ?>" class="product-image">
                                </div>
                            <?php endif; ?>
                            <input type="file" name="imagen" id="imagen" accept="image/*" class="form-control">
                            <div class="form-text">Deja este campo vacío para mantener la imagen actual.</div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check mt-4" hidden>
                                <input type="checkbox" name="destacado" id="destacado" class="form-check-input" <?php echo $producto['destacado'] ? 'checked' : ''; ?>>
                                <label for="destacado" class="form-check-label">Producto Destacado</label>
                            </div>
                        </div>
                        <div class="col-12">
                            <label for="descripcion" class="form-label">Descripción</label>
                            <textarea name="descripcion" id="descripcion" rows="4" class="form-control" required><?php echo htmlspecialchars($producto['descripcion']); ?></textarea>
                        </div>
                        <div class="col-12 mt-3">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-save me-2"></i>Guardar Cambios
                            </button>
                            <a href="productos.php" class="btn btn-secondary ms-2">
                                <i class="bi bi-x-circle me-2"></i>Cancelar
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>