<?php
session_start();
require '../conexion.php';

// Verificar si el usuario está logueado y es administrador
if (!isset($_SESSION['username']) || !isset($_SESSION['rol']) || $_SESSION['rol'] !== 'admin') {
    header("Location: ../login.php");
    exit;
}

// Obtener roles para el formulario
$query_roles = "SELECT * FROM roles";
$result_roles = mysqli_query($conn, $query_roles);

// Procesar la creación de usuario
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['crear_usuario'])) {
    $username = $_POST['username'];
    $password = $_POST['password']; // En producción, usar password_hash()
    $email = $_POST['email'];
    $rol_id = $_POST['rol_id'];
    
    // Verificar si el usuario ya existe
    $check_query = "SELECT id FROM usuarios WHERE username = ?";
    $check_stmt = $conn->prepare($check_query);
    $check_stmt->bind_param("s", $username);
    $check_stmt->execute();
    $check_result = $check_stmt->get_result();
    
    if ($check_result->num_rows > 0) {
        $error = "El nombre de usuario ya existe. Por favor, elige otro.";
    } else {
        // Crear el usuario
        $insert_query = "INSERT INTO usuarios (username, password, email, rol_id) VALUES (?, ?, ?, ?)";
        $insert_stmt = $conn->prepare($insert_query);
        $insert_stmt->bind_param("sssi", $username, $password, $email, $rol_id);
        
        if ($insert_stmt->execute()) {
            $success_message = "Usuario creado correctamente.";
        } else {
            $error = "Error al crear el usuario: " . $conn->error;
        }
    }
}

// Procesar la eliminación de usuario
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['eliminar_usuario'])) {
    $user_id = $_POST['user_id'];
    
    // No permitir eliminar al usuario actual
    if ($user_id == $_SESSION['user_id']) {
        $error = "No puedes eliminar tu propio usuario.";
    } else {
        $delete_query = "DELETE FROM usuarios WHERE id = ?";
        $delete_stmt = $conn->prepare($delete_query);
        $delete_stmt->bind_param("i", $user_id);
        
        if ($delete_stmt->execute()) {
            $success_message = "Usuario eliminado correctamente.";
        } else {
            $error = "Error al eliminar el usuario: " . $conn->error;
        }
    }
}

// Obtener la lista de usuarios
$query_usuarios = "SELECT u.id, u.username, u.email, r.nombre as rol FROM usuarios u JOIN roles r ON u.rol_id = r.id ORDER BY u.id DESC";
$result_usuarios = mysqli_query($conn, $query_usuarios);

// Obtener el nombre del rol para mostrar en la interfaz
$rol_usuario = $_SESSION['rol'];
$nombre_usuario = $_SESSION['username'];
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Usuarios</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="../CSS/style2.css">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm py-2">
        <div class="container-fluid">
            <button class="btn btn-link text-white d-lg-none" id="sidebar-toggle">
                <i class="bi bi-list fs-4"></i>
            </button>
            <a class="navbar-brand ms-2" href="#">
                <i class="bi bi-people fs-4 me-2"></i>
                <span class="fw-bold">Gestión de Usuarios</span>
            </a>
            <div class="ms-auto d-flex align-items-center">
                <div class="dropdown">
                    <button class="btn btn-primary dropdown-toggle d-flex align-items-center" type="button" id="userDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                        <img src="../Img/admin.jpg" alt="Admin" width="32" height="32" class="rounded-circle me-2">
                        <span><?php echo htmlspecialchars($nombre_usuario); ?></span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                        <li><a class="dropdown-item" href="#">Mi perfil</a></li>
                        <li><a class="dropdown-item" href="#">Configuración</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="../logout.php">Cerrar sesión</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>

    <!-- Overlay -->
    <div class="overlay" id="sidebar-overlay"></div>

    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="d-flex flex-column p-4">
            <div class="text-center mb-4">
                <img src="../Img/admin.jpg" alt="Perfil" class="rounded-circle mb-2" width="80" height="80">
                <h6 class="text-white"><?php echo htmlspecialchars($nombre_usuario); ?></h6>
                <span class="badge bg-light text-primary"><?php echo ucfirst(htmlspecialchars($rol_usuario)); ?></span>
            </div>

            <ul class="nav flex-column mt-2">
                <li class="nav-item">
                    <a class="nav-link" href="../Admin/dashboard.php">
                        <i class="bi bi-house-door me-2"></i> Dashboard
                    </a>
                </li>
                
                <?php if ($_SESSION['rol'] === 'admin'): ?>
                <li class="nav-item">
                    <a class="nav-link active" href="../Admin/usuarios.php">
                        <i class="bi bi-people me-2"></i> Usuarios
                    </a>
                </li>
                <?php endif; ?>
                
                <li class="nav-item">
                    <a class="nav-link" href="../Admin/carrusel.php">
                        <i class="bi bi-images me-2"></i> Carrusel
                    </a>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link" href="../Admin/productos.php">
                        <i class="bi bi-box-seam me-2"></i> Productos
                    </a>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link" href="../index.php">
                        <i class="bi bi-display me-2"></i> Ver sitio
                    </a>
                </li>
                
                <li class="nav-item mt-5">
                    <a class="nav-link bg-danger text-white" href="../logout.php">
                        <i class="bi bi-box-arrow-right me-2"></i> Cerrar sesión
                    </a>
                </li>
            </ul>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content content-wrapper">
        <div class="container-fluid">
            <header class="d-flex justify-content-between align-items-center py-3 mb-4 border-bottom">
                <h2 class="h2 fw-bold">Gestión de Usuarios</h2>
            </header>

            <!-- Mensajes de éxito o error -->
            <?php if(isset($success_message)): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo htmlspecialchars($success_message); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            
            <?php if(isset($error)): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo htmlspecialchars($error); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <!-- Formulario para crear usuario -->
            <div class="card shadow mb-4 form-card">
                <div class="card-header py-3 bg-primary bg-opacity-10">
                    <h6 class="m-0 font-weight-bold">Crear Nuevo Usuario</h6>
                </div>
                <div class="card-body">
                    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST">
                        <input type="hidden" name="crear_usuario" value="1">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="username" class="form-label">Nombre de Usuario</label>
                                <input type="text" name="username" id="username" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" name="email" id="email" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label for="password" class="form-label">Contraseña</label>
                                <input type="password" name="password" id="password" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label for="rol_id" class="form-label">Rol</label>
                                <select name="rol_id" id="rol_id" class="form-select" required>
                                    <?php 
                                    mysqli_data_seek($result_roles, 0);
                                    while ($rol = mysqli_fetch_assoc($result_roles)) {
                                        echo "<option value='" . $rol['id'] . "'>" . htmlspecialchars($rol['nombre']) . "</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="col-12 mt-3">
                                <button type="submit" class="btn btn-primary">Crear Usuario</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Lista de usuarios -->
            <div class="card shadow">
                <div class="card-header py-3 bg-primary bg-opacity-10">
                    <h6 class="m-0 font-weight-bold">Usuarios Registrados</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Usuario</th>
                                    <th>Email</th>
                                    <th>Rol</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($usuario = mysqli_fetch_assoc($result_usuarios)): ?>
                                <tr>
                                    <td><?php echo $usuario['id']; ?></td>
                                    <td><?php echo htmlspecialchars($usuario['username']); ?></td>
                                    <td><?php echo htmlspecialchars($usuario['email']); ?></td>
                                    <td><?php echo htmlspecialchars($usuario['rol']); ?></td>
                                    <td>
                                        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST" onsubmit="return confirm('¿Estás seguro de que deseas eliminar este usuario?');" class="d-inline">
                                            <input type="hidden" name="eliminar_usuario" value="1">
                                            <input type="hidden" name="user_id" value="<?php echo $usuario['id']; ?>">
                                            <button type="submit" class="btn btn-sm btn-danger">
                                                <i class="bi bi-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Sidebar toggle functionality
            const sidebarToggle = document.getElementById('sidebar-toggle');
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');
            
            if (sidebarToggle && sidebar && overlay) {
                sidebarToggle.addEventListener('click', function() {
                    sidebar.classList.toggle('show');
                    overlay.classList.toggle('show');
                });
                
                overlay.addEventListener('click', function() {
                    sidebar.classList.remove('show');
                    overlay.classList.remove('show');
                });
            }
            
            // Close sidebar when clicking on a nav link (mobile only)
            const navLinks = document.querySelectorAll('.sidebar .nav-link');
            navLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth < 992) {
                        sidebar.classList.remove('show');
                        overlay.classList.remove('show');
                    }
                });
            });
            
            // Handle window resize
            window.addEventListener('resize', function() {
                if (window.innerWidth >= 992) {
                    sidebar.classList.remove('show');
                    overlay.classList.remove('show');
                }
            });
        });
    </script>
</body>
</html>