<?php
session_start();
require 'conexion.php';

// Obtener imágenes del carrusel
$query = "SELECT * FROM carrusel WHERE activo = 1 ORDER BY orden ASC";
$resultado = mysqli_query($conn, $query);

// Debug information
$debug_info = "<!-- Debug Info: \n";
$debug_info .= "Number of carousel images: " . mysqli_num_rows($resultado) . "\n";
if (mysqli_num_rows($resultado) > 0) {
    $debug_info .= "Image details: \n";
    while ($row = mysqli_fetch_assoc($resultado)) {
        $debug_info .= "ID: " . $row['id'] . ", Image: " . $row['imagen_url'] . ", Active: " . $row['activo'] . "\n";
    }
    mysqli_data_seek($resultado, 0); // Reset the result pointer
}
$debug_info .= "-->";
echo $debug_info;

// Check if the img directory exists and is accessible
$img_dir = "img";
if (!file_exists($img_dir)) {
    echo "<!-- Warning: The img directory does not exist! -->";
    // Try to create it
    if (mkdir($img_dir, 0777, true)) {
        echo "<!-- Created img directory successfully -->";
    } else {
        echo "<!-- Failed to create img directory -->";
    }
} else {
    echo "<!-- The img directory exists -->";
    if (is_readable($img_dir)) {
        echo "<!-- and is readable -->";
    } else {
        echo "<!-- but is NOT readable! -->";
    }
    if (is_writable($img_dir)) {
        echo "<!-- and is writable -->";
    } else {
        echo "<!-- but is NOT writable! -->";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FERRETOOLS - Su tienda de herramientas profesionales</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="CSS/style.css">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="bi bi-tools"></i> FERRETOOLS
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Inicio</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Catálogo</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Ofertas</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Contacto</a>
                    </li>
                </ul>
                <div class="d-flex align-items-center">
                    <?php if(isset($_SESSION['username'])): ?>
                        <span class="text-light me-3">Bienvenido, <?php echo htmlspecialchars($_SESSION['username']); ?></span>
                        <?php if(isset($_SESSION['rol']) && ($_SESSION['rol'] == 'admin' || $_SESSION['rol'] == 'empleado')): ?>
                            <a href="Admin/dashboard.php" class="btn btn-outline-light btn-sm me-2">Panel <?php echo htmlspecialchars($_SESSION['username']); ?></a>
                        <?php endif; ?>
                        <a href="logout.php" class="btn btn-outline-light btn-sm">Cerrar Sesión</a>
                    <?php else: ?>
                        <a href="login.php" class="btn btn-outline-light">Iniciar Sesión</a>
                    <?php endif; ?>
                    <a href="#" class="btn btn-light ms-2">
                        <i class="bi bi-cart3"></i>
                        <span class="badge bg-danger">0</span>
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container text-center">
            <h1 class="hero-title">Herramientas profesionales para todos</h1>
            <p class="hero-text">La mejor calidad en herramientas para profesionales y aficionados al mejor precio</p>
            <a href="#productos" class="btn btn-light btn-lg px-4">Ver Productos</a>
        </div>
    </section>

    <!-- Main Content -->
    <div class="main-content">
        <div class="container">
            <!-- Carousel -->
            <div class="row mb-5">
                <div class="col-12">
                    <div id="mainCarousel" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-indicators">
                            <?php 
                            mysqli_data_seek($resultado, 0);
                            $i = 0;
                            while ($fila = mysqli_fetch_assoc($resultado)) {
                                echo '<button type="button" data-bs-target="#mainCarousel" data-bs-slide-to="'.$i.'" '.($i === 0 ? 'class="active"' : '').' aria-label="Slide '.($i+1).'"></button>';
                                $i++;
                            }
                            ?>
                        </div>
                        <div class="carousel-inner rounded shadow">
                            <?php 
                            mysqli_data_seek($resultado, 0);
                            $i = 0;
                            while ($fila = mysqli_fetch_assoc($resultado)) {
                                $active = $i === 0 ? 'active' : '';
                                echo '<div class="carousel-item '.$active.'">';
                                echo '<img src="img/'.htmlspecialchars($fila['imagen_url']).'" class="d-block w-100" alt="'.htmlspecialchars($fila['descripcion']).'">';
                                echo '<div class="carousel-caption d-none d-md-block">';
                                echo '<h5>'.htmlspecialchars($fila['descripcion']).'</h5>';
                                echo '</div>';
                                echo '</div>';
                                $i++;
                            }
                            ?>
                        </div>
                        <button class="carousel-control-prev" type="button" data-bs-target="#mainCarousel" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Anterior</span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#mainCarousel" data-bs-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Siguiente</span>
                        </button>
                    </div>
                </div>
            </div>
            

            <!-- Productos -->
            <div id="productos" class="row mb-5">
                <div class="col-12">
                    <h2 class="section-title">Nuestros Productos</h2>
                </div>
                
                <?php
                $query_productos = "SELECT * FROM productos";
                $result_productos = mysqli_query($conn, $query_productos);
                ?>
                
                <?php if(mysqli_num_rows($result_productos) > 0): ?>
                    <?php while($producto = mysqli_fetch_assoc($result_productos)): ?>
                        <div class="col-sm-6 col-md-4 col-lg-3">
                            <div class="card h-100">
                                
                                
                                <?php if(!empty($producto['imagen'])): ?>
                                    <img src="img/productos/<?php echo htmlspecialchars($producto['imagen']); ?>" class="card-img-top" alt="<?php echo htmlspecialchars($producto['nombre']); ?>">
                                <?php else: ?>
                                    <div class="card-img-top bg-light d-flex align-items-center justify-content-center">
                                        <i class="bi bi-image text-secondary" style="font-size: 3rem;"></i>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="card-body">
                                    <h5 class="card-title"><?php echo htmlspecialchars($producto['nombre']); ?></h5>
                                    <p class="card-text text-truncate"><?php echo htmlspecialchars($producto['descripcion']); ?></p>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="price">Q<?php echo number_format($producto['precio'], 2); ?></span>
                                        <?php if($producto['stock'] > 0): ?>
                                            <span class="badge bg-success stock-badge">En stock</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger stock-badge">Agotado</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="card-footer bg-white border-top-0">
                                    <div class="d-grid">
                                        <a href="producto.php?id=<?php echo $producto['id']; ?>" class="btn btn-primary">Ver detalles</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div class="col-12">
                        <div class="alert alert-info text-center">
                            No hay productos disponibles en este momento.
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Servicios -->
            <div class="row mb-5">
                <div class="col-12">
                    <h2 class="section-title">Nuestros Servicios</h2>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="d-flex">
                        <div class="flex-shrink-0">
                            <i class="bi bi-truck text-danger" style="font-size: 2rem;"></i>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h5>Envío Rápido</h5>
                            <p>Entregamos en todo el país en 24-48 horas laborables.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="d-flex">
                        <div class="flex-shrink-0">
                            <i class="bi bi-shield-check text-danger" style="font-size: 2rem;"></i>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h5>Garantía Extendida</h5>
                            <p>Todos nuestros productos cuentan con garantía de calidad.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="d-flex">
                        <div class="flex-shrink-0">
                            <i class="bi bi-headset text-danger" style="font-size: 2rem;"></i>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h5>Soporte Técnico</h5>
                            <p>Atención personalizada antes, durante y después de tu compra.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer>
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-md-6 mb-4 mb-lg-0">
                    <h5 class="footer-title">FERRETOOLS</h5>
                    <p>Tu tienda especializada en herramientas profesionales. Ofrecemos la mejor calidad y variedad para todos tus proyectos.</p>
                    <div class="mt-4">
                        <a href="#" class="social-icon"><i class="bi bi-facebook"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-instagram"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-twitter-x"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-youtube"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-4 mb-lg-0">
                    <h5 class="footer-title">Enlaces Rápidos</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="#" class="footer-link">Inicio</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Productos</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Ofertas</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Sobre Nosotros</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Contacto</a></li>
                    </ul>
                </div>
                <div class="col-lg-3 col-md-6 mb-4 mb-lg-0">
                    <h5 class="footer-title">Categorías</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="#" class="footer-link">Herramientas Eléctricas</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Herramientas Manuales</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Seguridad Industrial</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Jardinería</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Accesorios</a></li>
                    </ul>
                </div>
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-title">Contacto</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="bi bi-geo-alt me-2"></i> Av. Central, Zona 10, Guatemala
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-telephone me-2"></i> (502) 2222-3333
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-envelope me-2"></i> info@ferretools.com
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-clock me-2"></i> Lun-Sab: 8AM - 6PM
                        </li>
                    </ul>
                </div>
            </div>
            <hr class="my-4 bg-light">
            <div class="row">
                <div class="col-md-6 text-center text-md-start">
                    <p class="mb-0">© <?php echo date('Y'); ?> FERRETOOLS. Todos los derechos reservados.</p>
                </div>
                <div class="col-md-6 text-center text-md-end">
                    <p class="mb-0">Diseñado por Pablo Garcia</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>