<?php
session_start();

// Check if user is logged in
if (!isset($_SESSION["username"]) || !isset($_SESSION["rol"])) {
    header("Location: index.php");
    exit;
}

$username = $_SESSION["username"];
$rol = $_SESSION["rol"];
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inicio - Sistema</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">
    <nav class="bg-white shadow-md">
        <div class="container mx-auto px-6 py-3 flex justify-between items-center">
            <span class="text-xl font-bold text-indigo-600">Sistema</span>
            <div class="flex items-center space-x-4">
                <span class="text-gray-700">Bienvenido, <?php echo htmlspecialchars($username); ?> (<?php echo htmlspecialchars($rol); ?>)</span>
                <a href="logout.php" class="px-4 py-2 bg-red-500 text-white rounded hover:bg-red-600 transition">Cerrar sesión</a>
            </div>
        </div>
    </nav>

    <div class="container mx-auto px-6 py-8">
        <h1 class="text-3xl font-bold text-gray-800 mb-6">Panel de Control</h1>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php if ($rol === 'admin' ): ?>
            <div class="bg-white p-6 rounded-lg shadow-md">
                <h2 class="text-xl font-semibold text-gray-800 mb-4">Administración de Usuarios</h2>
                <p class="text-gray-600 mb-4">Gestiona los usuarios del sistema.</p>
                <a href="usuarios.php" class="inline-block px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700 transition">Acceder</a>
            </div>
            <?php endif; ?>
            
            <div class="bg-white p-6 rounded-lg shadow-md">
                <h2 class="text-xl font-semibold text-gray-800 mb-4">Productos</h2>
                <p class="text-gray-600 mb-4">Visualiza y gestiona los productos.</p>
                <a href="productos.php" class="inline-block px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700 transition">Acceder</a>
            </div>
            
            <?php if ($rol === 'admin'): ?>
            <div class="bg-white p-6 rounded-lg shadow-md">
                <h2 class="text-xl font-semibold text-gray-800 mb-4">Carrusel</h2>
                <p class="text-gray-600 mb-4">Administra las imágenes del carrusel.</p>
                <a href="carrusel.php" class="inline-block px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700 transition">Acceder</a>
            </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>

