<?php
ob_start(); // Inicia el buffer de salida
session_start();
require 'conexion.php';

// Verificar si ya hay una sesión activa
if (isset($_SESSION['username'])) {
    header("Location: index.php");
    exit;
}

// Verificar si existen los roles necesarios
function verificarRoles() {
    global $conn;
    
    // Verificar o crear el rol de administrador
    $stmt = $conn->prepare("SELECT id FROM roles WHERE nombre = 'admin'");
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows == 0) {
        // Si no existe el rol de administrador, crearlo
        $stmt = $conn->prepare("INSERT INTO roles (nombre) VALUES ('admin')");
        $stmt->execute();
        $admin_role_id = $conn->insert_id;
    } else {
        $row = $result->fetch_assoc();
        $admin_role_id = $row['id'];
    }
    
    // Verificar o crear el rol de empleado
    $stmt = $conn->prepare("SELECT id FROM roles WHERE nombre = 'empleado'");
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows == 0) {
        // Si no existe el rol de empleado, crearlo
        $stmt = $conn->prepare("INSERT INTO roles (nombre) VALUES ('empleado')");
        $stmt->execute();
    }
    // Verificar o crear el rol de usuario
     $stmt = $conn->prepare("SELECT id FROM roles WHERE nombre = 'usuario'");
     $stmt->execute();
     $result = $stmt->get_result();
     
     if ($result->num_rows == 0) {
         // Si no existe el rol de usuario, crearlo
         $stmt = $conn->prepare("INSERT INTO roles (nombre) VALUES ('usuario')");
         $stmt->execute();
     }
    
    // Verificar si existe un usuario con rol de administrador
    $stmt = $conn->prepare("SELECT id FROM usuarios WHERE rol_id = ?");
    $stmt->bind_param("i", $admin_role_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows == 0) {
        // No existe un administrador
        return false;
    }
    
    return true;
}

$admin_exists = verificarRoles();
$mostrar_form_admin = false;

// Procesar la creación de un administrador
if (!$admin_exists && isset($_POST['crear_admin'])) {
    $admin_username = $_POST['admin_username'];
    $admin_password = $_POST['admin_password']; // En producción, usar password_hash()
    $admin_email = $_POST['admin_email'];
    
    // Obtener el ID del rol de administrador
    $stmt = $conn->prepare("SELECT id FROM roles WHERE nombre = 'admin'");
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $admin_role_id = $row['id'];
    
    // Crear el usuario administrador
    $stmt = $conn->prepare("INSERT INTO usuarios (username, password, email, rol_id) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("sssi", $admin_username, $admin_password, $admin_email, $admin_role_id);
    
    if ($stmt->execute()) {
        $success_message = "Usuario administrador creado correctamente. Ahora puedes iniciar sesión.";
    } else {
        $error = "Error al crear el administrador: " . $conn->error;
    }
} elseif (!$admin_exists) {
    $mostrar_form_admin = true;
}

// Procesar el inicio de sesión
if ($_SERVER["REQUEST_METHOD"] == "POST" && !isset($_POST['crear_admin'])) {
    $input_username = $_POST["username"];
    $input_password = $_POST["password"];

    // Consultar el usuario
    $stmt = $conn->prepare("SELECT u.id, u.password, u.username, r.nombre as rol FROM usuarios u 
                           JOIN roles r ON u.rol_id = r.id 
                           WHERE u.username = ?");
    $stmt->bind_param("s", $input_username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 1) {
        $row = $result->fetch_assoc();
        if ($input_password === $row['password']) { // En producción, usar password_verify()
            $_SESSION["username"] = $row['username'];
            $_SESSION["user_id"] = $row['id'];
            $_SESSION["rol"] = $row['rol'];
            
if ($row['rol'] === 'admin' || $row['rol'] === 'empleado') {
    echo "<script>window.location='Admin/dashboard.php';</script>";
    exit;
}else if($row['rol'] === 'usuario'){
    echo "<script>window.location='index.php';</script>";
    exit;
} else {
    echo "<script>window.location='index.php';</script>";
    exit;
}
        } else {
            $error = "Nombre de usuario o contraseña incorrectos.";
        }
    } else {
        $error = "Nombre de usuario o contraseña incorrectos.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Page</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .bg-custom {
            background: linear-gradient(135deg, #4158D0 0%, #C850C0 46%, #FFCC70 100%);
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
        }
        
        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            z-index: 1;
        }
        
        .login-container {
            position: relative;
            z-index: 2;
            margin-top: 100px;
        }
        
        .navbar-custom {
            background-color: rgba(255, 255, 255, 0.9);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: relative;
            z-index: 10;
        }
    </style>
</head>
<body>
    <div class="bg-custom"></div>
    <div class="overlay"></div>


    <div class="container login-container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow">
                    <div class="card-body p-4">
                        <?php if ($mostrar_form_admin): ?>
                            <h2 class="text-center mb-4">Crear Administrador</h2>
                            <p class="text-center text-muted mb-4">
                                No se ha detectado ningún administrador. Por favor, crea uno para comenzar.
                            </p>

                            <?php if(isset($error)) echo "<div class='alert alert-danger text-center'>".htmlspecialchars($error)."</div>"; ?>

                            <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST">
                                <input type="hidden" name="crear_admin" value="1">
                                <div class="mb-3">
                                    <label for="admin_username" class="form-label">Nombre de Usuario</label>
                                    <input id="admin_username" name="admin_username" type="text" required class="form-control" placeholder="Nombre de Usuario">
                                </div>
                                <div class="mb-3">
                                    <label for="admin_email" class="form-label">Email</label>
                                    <input id="admin_email" name="admin_email" type="email" required class="form-control" placeholder="Email">
                                </div>
                                <div class="mb-3">
                                    <label for="admin_password" class="form-label">Contraseña</label>
                                    <input id="admin_password" name="admin_password" type="password" required class="form-control" placeholder="Contraseña">
                                </div>
                                <button type="submit" class="btn btn-primary w-100 py-2">
                                    Crear Administrador
                                </button>
                            </form>
                        <?php else: ?>
                            <h2 class="text-center mb-4">Inicia Sesión</h2>

                            <?php if(isset($success_message)) echo "<div class='alert alert-success text-center'>".htmlspecialchars($success_message)."</div>"; ?>
                            <?php if(isset($error)) echo "<div class='alert alert-danger text-center'>".htmlspecialchars($error)."</div>"; ?>

                            <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST">
                                <div class="mb-3">
                                    <label for="username" class="form-label">Nombre de Usuario</label>
                                    <input id="username" name="username" type="text" required class="form-control" placeholder="Nombre de Usuario">
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label">Contraseña</label>
                                    <input id="password" name="password" type="password" required class="form-control" placeholder="Contraseña">
                                </div>
                                <button type="submit" class="btn btn-primary w-100 py-2">
                                    Iniciar sesión
                                </button>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>