<?php
session_start();
require 'conexion.php';

// Verificar si se proporcionó un ID de producto
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: index.php");
    exit;
}

$producto_id = $_GET['id'];

// Obtener los datos del producto
$query = "SELECT * FROM productos WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $producto_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    header("Location: index.php");
    exit;
}

$producto = $result->fetch_assoc();

// Obtener productos relacionados (misma categoría o destacados)
$query_relacionados = "SELECT * FROM productos WHERE id != ? AND destacado = 1 LIMIT 4";
$stmt_relacionados = $conn->prepare($query_relacionados);
$stmt_relacionados->bind_param("i", $producto_id);
$stmt_relacionados->execute();
$result_relacionados = $stmt_relacionados->get_result();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($producto['nombre']); ?> - FERRETOOLS</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="CSS/style.css">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="bi bi-tools"></i> FERRETOOLS
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Inicio</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#">Catálogo</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Ofertas</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Contacto</a>
                    </li>
                </ul>
                <div class="d-flex align-items-center">
                    <?php if(isset($_SESSION['username'])): ?>
                        <span class="text-light me-3">Bienvenido, <?php echo htmlspecialchars($_SESSION['username']); ?></span>
                        <?php if(isset($_SESSION['rol']) && ($_SESSION['rol'] == 'admin' || $_SESSION['rol'] == 'empleado')): ?>
                            <a href="Admin/dashboard.php" class="btn btn-outline-light btn-sm me-2">Panel <?php echo htmlspecialchars($_SESSION['username']); ?></a>
                        <?php endif; ?>
                        <a href="logout.php" class="btn btn-outline-light btn-sm">Cerrar Sesión</a>
                    <?php else: ?>
                        <a href="login.php" class="btn btn-outline-light">Iniciar Sesión</a>
                    <?php endif; ?>
                    <a href="#" class="btn btn-light ms-2">
                        <i class="bi bi-cart3"></i>
                        <span class="badge bg-danger">0</span>
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section for Product -->
    <section class="hero-product">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php" class="text-white">Inicio</a></li>
                    <li class="breadcrumb-item"><a href="#" class="text-white">Productos</a></li>
                    <li class="breadcrumb-item active text-white-50" aria-current="page"><?php echo htmlspecialchars($producto['nombre']); ?></li>
                </ol>
            </nav>
            <h1 class="display-4"><?php echo htmlspecialchars($producto['nombre']); ?></h1>
            <p class="lead">Descubre la calidad y desempeño que necesitas para tus proyectos</p>
        </div>
    </section>

    <!-- Main Content -->
    <div class="container py-5">
        <div class="row">
            <!-- Product Details -->
            <div class="col-lg-12 mb-5">
                <div class="card border-0 shadow">
                    <div class="row g-0">
                        <div class="col-md-6 position-relative">
                            
                            <?php if(!empty($producto['imagen'])): ?>
                                <img src="img/productos/<?php echo htmlspecialchars($producto['imagen']); ?>" class="img-fluid product-image rounded-start" alt="<?php echo htmlspecialchars($producto['nombre']); ?>">
                            <?php else: ?>
                                <div class="bg-light d-flex align-items-center justify-content-center product-image rounded-start">
                                    <i class="bi bi-image text-secondary" style="font-size: 5rem;"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-6">
                            <div class="card-body p-4 p-lg-5">
                                <h2 class="card-title fw-bold mb-3"><?php echo htmlspecialchars($producto['nombre']); ?></h2>
                                
                                <div class="d-flex justify-content-between align-items-center mb-4">
                                    <span class="fs-2 fw-bold text-danger">Q<?php echo number_format($producto['precio'], 2); ?></span>
                                    <?php if($producto['stock'] > 0): ?>
                                        <span class="badge bg-success px-3 py-2">En stock: <?php echo $producto['stock']; ?> unidades</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger px-3 py-2">Agotado</span>
                                    <?php endif; ?>
                                </div>
                                
                                <p class="card-text mb-4"><?php echo nl2br(htmlspecialchars($producto['descripcion'])); ?></p>
                                
                                <div class="d-grid gap-2">
                                    <button type="button" class="btn btn-danger btn-lg" <?php echo $producto['stock'] <= 0 ? 'disabled' : ''; ?>>
                                        <i class="bi bi-cart-plus me-2"></i>Añadir al carrito
                                    </button>
                                </div>
                                
                                <div class="mt-4 text-muted">
                                    <small>Fecha de creación: <?php echo date('d/m/Y', strtotime($producto['fecha_creacion'])); ?></small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product Features (Optional) -->
            <div class="col-lg-12 mb-5">
                <div class="row g-4">
                    <div class="col-md-4">
                        <div class="card h-100 border-0 shadow-sm text-center p-3">
                            <div class="card-body">
                                <i class="bi bi-truck text-danger mb-3" style="font-size: 2rem;"></i>
                                <h5 class="card-title">Envío Rápido</h5>
                                <p class="card-text">Entregamos en todo el país en 24-48 horas laborables.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card h-100 border-0 shadow-sm text-center p-3">
                            <div class="card-body">
                                <i class="bi bi-shield-check text-danger mb-3" style="font-size: 2rem;"></i>
                                <h5 class="card-title">Garantía Extendida</h5>
                                <p class="card-text">Todos nuestros productos cuentan con garantía de calidad.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card h-100 border-0 shadow-sm text-center p-3">
                            <div class="card-body">
                                <i class="bi bi-arrow-return-left text-danger mb-3" style="font-size: 2rem;"></i>
                                <h5 class="card-title">Devolución Sin Problemas</h5>
                                <p class="card-text">30 días para devoluciones si no estás satisfecho con tu compra.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer>
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-md-6 mb-4 mb-lg-0">
                    <h5 class="footer-title">FERRETOOLS</h5>
                    <p>Tu tienda especializada en herramientas profesionales. Ofrecemos la mejor calidad y variedad para todos tus proyectos.</p>
                    <div class="mt-4">
                        <a href="#" class="social-icon"><i class="bi bi-facebook"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-instagram"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-twitter-x"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-youtube"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-4 mb-lg-0">
                    <h5 class="footer-title">Enlaces Rápidos</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="index.php" class="footer-link">Inicio</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Productos</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Ofertas</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Sobre Nosotros</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Contacto</a></li>
                    </ul>
                </div>
                <div class="col-lg-3 col-md-6 mb-4 mb-lg-0">
                    <h5 class="footer-title">Categorías</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="#" class="footer-link">Herramientas Eléctricas</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Herramientas Manuales</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Seguridad Industrial</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Jardinería</a></li>
                        <li class="mb-2"><a href="#" class="footer-link">Accesorios</a></li>
                    </ul>
                </div>
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-title">Contacto</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="bi bi-geo-alt me-2"></i> Av. Central, Zona 10, Guatemala
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-telephone me-2"></i> (502) 2222-3333
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-envelope me-2"></i> info@ferretools.com
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-clock me-2"></i> Lun-Sab: 8AM - 6PM
                        </li>
                    </ul>
                </div>
            </div>
            <hr class="my-4 bg-light">
            <div class="row">
                <div class="col-md-6 text-center text-md-start">
                    <p class="mb-0">© <?php echo date('Y'); ?> FERRETOOLS. Todos los derechos reservados.</p>
                </div>
                <div class="col-md-6 text-center text-md-end">
                    <p class="mb-0">Diseñado por Pablo Garcia</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>